<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

class XenCentral_AdServer_Route_PrefixPublic_Default implements XenForo_Route_Interface
{
    /**
     * Match a specific route for an already matched prefix.
     *
     * @see XenForo_Route_Interface::match()
     */
    public function match($routePath, Zend_Controller_Request_Http $request, XenForo_Router $router)
    {
        $routeArray = explode('/', $routePath);

        $basePath = array_shift($routeArray);

        switch ($basePath) {
            case 'delivery':
                return $router->getRouteMatch('XenCentral_AdServer_ControllerPublic_Delivery', implode('/', $routeArray), 'ads');
                break;
            case 'zone':
                $action = $router->resolveActionWithIntegerParam(implode('/', $routeArray), $request, 'zoneId', 'index');
                return $router->getRouteMatch('XenCentral_AdServer_ControllerPublic_Zone', $action, 'ads');
                break;
            case 'banner':
                $action = $router->resolveActionWithIntegerParam(implode('/', $routeArray), $request, 'bannerId', 'index');
                return $router->getRouteMatch('XenCentral_AdServer_ControllerPublic_Banner', $action, 'ads');
            case 'stats':
                $action=implode('/', $routeArray);
                return $router->getRouteMatch('XenCentral_AdServer_ControllerPublic_Stats', $action, 'ads');
            case 'credit':
                $action=implode('/', $routeArray);
                return $router->getRouteMatch('XenCentral_AdServer_ControllerPublic_Credit', $action, 'ads');
            default:
                array_unshift($routeArray, $basePath);
                return $router->getRouteMatch('XenCentral_AdServer_ControllerPublic_Index', implode('/', $routeArray), 'ads');
                break;
        }
        return false;
    }

    /**
     * Method to build a link to the specified page/action with the provided
     * data and params.
     *
     * @see XenForo_Route_BuilderInterface
     */
    public function buildLink($originalPrefix, $outputPrefix, $action, $extension, $data, array &$extraParams)
    {
        if (strpos($action, '/') === false) {
            return XenForo_Link::buildBasicLink($outputPrefix, $action, $extension);
        }

        $routeArray = explode('/', $action);

        $basePath = array_shift($routeArray);

        switch ($basePath) {
            case 'zone':
                return XenForo_Link::buildBasicLinkWithIntegerParam($outputPrefix . '/' . $basePath, array_shift($routeArray), $extension, $data, 'zoneId', 'title');
                break;
            case 'banner':
                return XenForo_Link::buildBasicLinkWithIntegerParam($outputPrefix . '/' . $basePath, array_shift($routeArray), $extension, $data, 'bannerId', 'title');
                break;
        }

        return false;
    }
}